/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public record FOTLocationPredicate(Optional<Continentalness> continentalness, Optional<PeakTypes> peakType, Optional<Boolean> hasRaids) {
    public static final Codec<FOTLocationPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Continentalness.CODEC.optionalFieldOf("continentalness").forGetter(FOTLocationPredicate::continentalness), (App)PeakTypes.CODEC.optionalFieldOf("peak_type").forGetter(FOTLocationPredicate::peakType), (App)Codec.BOOL.optionalFieldOf("has_raids").forGetter(FOTLocationPredicate::hasRaids)).apply((Applicative)instance, FOTLocationPredicate::new));

    public boolean matches(ServerLevel level, double x, double y, double z) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean loaded = level.isLoaded(blockPos);
        if (!loaded) {
            return false;
        }
        if (this.continentalness.isPresent()) {
            return this.continentalness.get() == TerrainUtils.getContinentalness(level, blockPos);
        }
        if (this.peakType.isPresent()) {
            return this.peakType.get() == TerrainUtils.getPeakTypes(level, blockPos);
        }
        if (this.hasRaids.isPresent()) {
            return this.hasRaids.get().booleanValue() == level.isRaided(blockPos);
        }
        return false;
    }

    public static class Builder {
        private Optional<Continentalness> continentalness = Optional.empty();
        private Optional<PeakTypes> peakType = Optional.empty();
        private Optional<Boolean> hasRaids = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public Builder setContinentalness(Continentalness continentalness) {
            this.continentalness = Optional.of(continentalness);
            return this;
        }

        public Builder setPeakType(PeakTypes peakType) {
            this.peakType = Optional.of(peakType);
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = Optional.of(true);
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.continentalness, this.peakType, this.hasRaids);
        }
    }
}

